/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWEditArrayFieldDialog;
import filenet.vw.toolkit.utils.dialog.VWEditXMLFieldDialog;
import filenet.vw.toolkit.utils.dialog.VWFileURLDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableMouseAdapter;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class VWFieldsCellEditor
implements TableCellEditor,
ActionListener,
ItemListener,
FocusListener,
KeyListener {
    private static final int FIELD_TYPE_UNKNOWN = -1;
    private static final int EDITOR_UNKNOWN = -1;
    private static final int EDITOR_TEXT_FIELD = 0;
    private static final int EDITOR_COMBOBOX = 1;
    private static final int EDITOR_ARRAY_DIALOG = 2;
    private static final int EDITOR_ASSIGN_ATTACHMENT_DIALOG = 3;
    private static final int EDITOR_WORKFLOW_GROUP_DIALOG = 4;
    private static final int EDITOR_XML_DIALOG = 5;
    private static final int VALUE_NA = 0;
    private static final int VALUE_NO_CHANGE = 1;
    private static final int VALUE_UPDATED = 2;
    private static final int VALUE_INVALID = 3;
    private Frame m_parentFrame = null;
    private JTable m_table = null;
    private int m_row = -1;
    private int m_col = -1;
    protected EventListenerList m_listenerList = new EventListenerList();
    protected transient ChangeEvent m_changeEvent = null;
    protected int m_nClickCountToStart = 2;
    private boolean m_bStarted = false;
    private boolean m_bEnabled = false;
    private Object m_currentValue = null;
    private JComboBox m_comboBox = null;
    private boolean m_bArray = false;
    private boolean m_bReadOnly = false;
    protected int m_nEditorType = -1;
    protected String m_fieldname = null;
    protected int m_nFieldType = -1;
    private boolean m_bUpdatingValue = false;
    private JTextField m_textField = null;
    protected JComponent m_editorComponent = null;
    private VWEditArrayFieldDialog m_editArrayDialog = null;
    private IVWIDMDialog m_assignAttachmentDialog = null;
    private int m_nAssignAttachmentDialogReturn = 1;
    private Object m_sampleValue = null;
    private VWEditXMLFieldDialog m_editXMLDialog = null;
    private int m_nEditXMLDialogReturn = 1;
    private boolean m_bRuntimeData = true;
    public static final DateFormat[] s_dateTimeFormatters = new DateFormat[]{DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(3, 1), DateFormat.getDateTimeInstance(3, 0), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(2, 1), DateFormat.getDateTimeInstance(2, 0), DateFormat.getDateTimeInstance(1, 2), DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(1, 0), DateFormat.getDateTimeInstance(0, 2), DateFormat.getDateTimeInstance(0, 1), DateFormat.getDateTimeInstance(0, 0), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(1, 3), DateFormat.getDateTimeInstance(0, 3), DateFormat.getInstance()};

    public VWFieldsCellEditor(Frame parentFrame) {
        this.m_parentFrame = parentFrame;
        this.m_textField = new JTextField();
        this.m_textField.addActionListener(this);
        this.m_textField.addFocusListener(this);
        String[] booleanValues = new String[]{VWResource.s_true, VWResource.s_false};
        this.m_comboBox = new JComboBox<String>(booleanValues);
        this.m_comboBox.setRenderer(new VWLabelListCellRenderer());
        this.m_comboBox.addItemListener(this);
        this.m_comboBox.addFocusListener(this);
        this.m_comboBox.addActionListener(this);
    }

    public VWFieldsCellEditor(Frame parentFrame, boolean bRuntimeData) {
        this(parentFrame);
        this.m_bRuntimeData = bRuntimeData;
    }

    public boolean isValid() {
        if (this.m_bStarted && this.m_bEnabled) {
            int result = this.updateCurrentValue();
            return result != 3;
        }
        return true;
    }

    public void setFieldType(Object obj) {
        if (obj == null) {
            this.m_nFieldType = -1;
            return;
        }
        this.m_nFieldType = obj instanceof Integer ? 1 : (obj instanceof Boolean ? 4 : (obj instanceof Double ? 8 : (obj instanceof Date ? 16 : (obj instanceof String ? 2 : (obj instanceof VWGuid ? 512 : -1)))));
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        if (this.m_table != null) {
            this.m_table.removeKeyListener(this);
            this.m_table = null;
        }
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                this.m_listenerList.remove(CellEditorListener.class, (CellEditorListener)listeners[i + 1]);
            }
            this.m_listenerList = null;
        }
        this.m_changeEvent = null;
        this.m_currentValue = null;
        if (this.m_comboBox != null) {
            this.m_comboBox.removeItemListener(this);
            this.m_comboBox.removeFocusListener(this);
            this.m_comboBox.removeActionListener(this);
            this.m_comboBox = null;
        }
        this.m_fieldname = null;
        if (this.m_textField != null) {
            this.m_textField.removeActionListener(this);
            this.m_textField.removeFocusListener(this);
            this.m_textField = null;
        }
        this.m_editorComponent = null;
        if (this.m_editArrayDialog != null) {
            this.m_editArrayDialog.removeReferences();
            this.m_editArrayDialog = null;
        }
        this.m_assignAttachmentDialog = null;
        if (this.m_editXMLDialog != null) {
            this.m_editXMLDialog.removeReferences();
            this.m_editXMLDialog = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_table = table;
        this.m_bEnabled = true;
        this.m_bStarted = false;
        Object obj = null;
        if (this.m_table != null) {
            this.m_table.addKeyListener(this);
            this.m_row = this.m_table.getSelectedRow();
            this.m_col = this.m_table.getSelectedColumn();
        } else {
            this.m_row = -1;
            this.m_col = -1;
        }
        if (value instanceof VWFieldDataForTable) {
            VWFieldDataForTable data = (VWFieldDataForTable)value;
            value = data.getValue();
            this.m_fieldname = data.getFieldName();
            this.m_bArray = data.isArray();
            this.m_nFieldType = data.getType();
            this.m_bReadOnly = data.getReadOnly();
            this.m_sampleValue = data.getSampleValue();
        }
        this.m_currentValue = value;
        if (value != null) {
            if (value instanceof Vector) {
                obj = ((Vector)value).elementAt(0);
                if (obj == null) return this.m_textField;
                this.m_bArray = obj.getClass().isArray();
            } else {
                Object[] array;
                obj = value;
                this.m_bArray = value.getClass().isArray();
                if (this.m_bArray && value instanceof Object[] && (array = (Object[])value).length == 0) {
                    value = null;
                }
            }
        }
        if (this.m_bArray) {
            this.m_textField.setEditable(false);
            this.m_textField.setText(VWResource.s_editing);
            this.m_nEditorType = 2;
            if (this.m_editArrayDialog == null) {
                VWFieldDataForTable dataForTable = new VWFieldDataForTable(this.m_nFieldType, this.m_bArray, value, this.m_fieldname, this.m_sampleValue);
                this.m_editArrayDialog = new VWEditArrayFieldDialog(this.m_parentFrame, dataForTable, this.m_bReadOnly, this.m_bRuntimeData);
            }
            if (value != null && !this.m_editArrayDialog.isCanceled()) {
                this.m_currentValue = value;
            }
            this.m_textField.setComponentOrientation(table.getComponentOrientation());
            return this.m_textField;
        }
        if (obj instanceof VWAttachment) {
            this.m_textField.setEditable(false);
            this.m_textField.setText(VWResource.s_editing);
            try {
                if (this.m_assignAttachmentDialog == null) {
                    IVWIDMItem idmDoc = null;
                    String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_select_withHK);
                    this.m_assignAttachmentDialog = VWIDMBaseFactory.instance().getBrowseDialog(idmDoc, 95, resources[0], null);
                    this.m_assignAttachmentDialog.setTitle(VWResource.s_browseForItem);
                    this.m_assignAttachmentDialog.setButtonMnemonic(resources[1]);
                    this.m_assignAttachmentDialog.setButtonTooltip(VWResource.s_select);
                }
                this.m_nEditorType = 3;
                this.m_nFieldType = 32;
            }
            catch (Exception e) {
                VWDebug.logException(e);
                JOptionPane.showMessageDialog(this.m_parentFrame, e.getLocalizedMessage(), VWResource.s_assignAttachment, 0);
                this.m_assignAttachmentDialog = null;
                this.cancelCellEditing();
            }
            if (value != null) {
                this.m_currentValue = value;
            }
            this.m_textField.setComponentOrientation(table.getComponentOrientation());
            return this.m_textField;
        }
        if (obj instanceof VWParticipant) {
            this.m_textField.setEditable(false);
            this.m_textField.setText(VWResource.s_editing);
            this.m_nEditorType = 4;
            this.m_nFieldType = 64;
            if (value != null) {
                this.m_currentValue = value;
            }
            this.m_textField.setComponentOrientation(table.getComponentOrientation());
            return this.m_textField;
        }
        if (obj instanceof VWXMLData || this.m_nFieldType == 128) {
            this.m_textField.setEditable(false);
            this.m_textField.setText(VWResource.s_editing);
            try {
                if (this.m_editXMLDialog == null) {
                    VWXMLData vwXMLData = null;
                    if (obj != null && obj instanceof VWXMLData) {
                        vwXMLData = (VWXMLData)obj;
                        if (this.m_sampleValue != null && this.m_sampleValue instanceof String && vwXMLData.getXML() != null && vwXMLData.getXML().length() == 0) {
                            vwXMLData.setXML((String)this.m_sampleValue);
                        }
                    }
                    this.m_editXMLDialog = new VWEditXMLFieldDialog(this.m_parentFrame, this.m_bRuntimeData, vwXMLData);
                }
                this.m_nEditorType = 5;
                this.m_nFieldType = 128;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_error, 0);
                this.m_editXMLDialog = null;
                this.cancelCellEditing();
            }
            if (value != null) {
                this.m_currentValue = value;
            }
            this.m_textField.setComponentOrientation(table.getComponentOrientation());
            return this.m_textField;
        }
        if (obj instanceof Boolean || this.m_nFieldType == 4) {
            this.m_nFieldType = 4;
            this.m_nEditorType = 1;
            this.m_editorComponent = this.m_comboBox;
            if (obj != null && obj instanceof Boolean) {
                if (((Boolean)obj).booleanValue()) {
                    this.m_comboBox.setSelectedIndex(0);
                } else {
                    this.m_comboBox.setSelectedIndex(1);
                }
            } else {
                this.m_comboBox.setSelectedIndex(0);
            }
            this.m_comboBox.setComponentOrientation(table.getComponentOrientation());
            return this.m_comboBox;
        }
        String string = VWFieldsCellRenderer.toString(value);
        this.m_textField.setEditable(true);
        this.m_textField.setText(string);
        this.m_nEditorType = 0;
        this.m_editorComponent = this.m_textField;
        if (value instanceof Integer) {
            this.m_nFieldType = 1;
        } else if (value instanceof Double) {
            this.m_nFieldType = 8;
        } else if (value instanceof Date) {
            this.m_nFieldType = 16;
        } else if (value instanceof String) {
            this.m_nFieldType = 2;
        } else if (value instanceof VWGuid) {
            this.m_nFieldType = 512;
        }
        this.m_textField.setComponentOrientation(table.getComponentOrientation());
        return this.m_textField;
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.m_listenerList.add(CellEditorListener.class, l);
    }

    public void cancelCellEditing() {
        this.m_bStarted = false;
        this.fireEditingCanceled();
        this.m_bEnabled = false;
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public int getClickCountToStart() {
        return this.m_nClickCountToStart;
    }

    public Component getComponent() {
        return this.m_editorComponent;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return anEvent == null || !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= this.m_nClickCountToStart;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.m_listenerList.remove(CellEditorListener.class, l);
    }

    public void setClickCountToStart(int count) {
        this.m_nClickCountToStart = count;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        boolean bRetValue = true;
        int nResult = 0;
        if (this.isCellEditable(anEvent)) {
            switch (this.m_nEditorType) {
                case 2: {
                    if (this.m_editArrayDialog == null) break;
                    this.m_editArrayDialog.setVisible(true);
                    if (this.m_editArrayDialog.isVisible()) break;
                    nResult = this.updateCurrentValue();
                    if (nResult == 2) {
                        this.fireEditingStopped();
                    } else if (nResult != 0) {
                        this.cancelCellEditing();
                    }
                    this.m_editArrayDialog.removeReferences();
                    this.m_editArrayDialog = null;
                    if (this.m_table == null || !(this.m_table instanceof VWTable)) break;
                    this.m_table.addMouseListener(new VWTableMouseAdapter((VWTable)this.m_table));
                    break;
                }
                case 3: {
                    if (this.m_assignAttachmentDialog == null) break;
                    try {
                        this.m_nAssignAttachmentDialogReturn = this.m_assignAttachmentDialog.showDialog(this.m_parentFrame);
                        nResult = this.updateCurrentValue();
                        if (nResult == 2) {
                            this.fireEditingStopped();
                        } else if (nResult != 0) {
                            this.cancelCellEditing();
                        }
                        this.m_assignAttachmentDialog = null;
                        if (this.m_table == null || !(this.m_table instanceof VWTable)) break;
                        this.m_table.addMouseListener(new VWTableMouseAdapter((VWTable)this.m_table));
                    }
                    catch (Exception e) {
                        VWDebug.logException(e);
                        JOptionPane.showMessageDialog(this.m_parentFrame, e.getLocalizedMessage(), VWResource.s_assignAttachment, 0);
                        this.cancelCellEditing();
                    }
                    break;
                }
                case 5: {
                    if (this.m_editXMLDialog == null) break;
                    try {
                        this.m_editXMLDialog.setVisible(true);
                        this.m_nEditXMLDialogReturn = this.m_editXMLDialog.getExitStatus();
                        nResult = this.updateCurrentValue();
                        if (nResult == 2) {
                            this.fireEditingStopped();
                        } else if (nResult != 0) {
                            this.cancelCellEditing();
                        }
                        this.m_editXMLDialog = null;
                        if (this.m_table == null || !(this.m_table instanceof VWTable)) break;
                        this.m_table.addMouseListener(new VWTableMouseAdapter((VWTable)this.m_table));
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_error, 0);
                        this.cancelCellEditing();
                    }
                    break;
                }
                default: {
                    bRetValue = this.startCellEditing(anEvent);
                }
            }
        }
        return bRetValue;
    }

    public boolean startCellEditing(EventObject evt) {
        this.m_bStarted = false;
        switch (this.m_nEditorType) {
            case 0: {
                if (evt == null) {
                    this.m_textField.requestFocus();
                }
                this.m_bStarted = true;
                break;
            }
            case 1: {
                if (!(evt instanceof AWTEvent)) break;
                this.m_bStarted = true;
                break;
            }
            case 2: {
                this.m_bStarted = true;
                break;
            }
            case 3: {
                this.m_bStarted = true;
                break;
            }
            case 4: {
                this.m_bStarted = true;
                break;
            }
            case 5: {
                this.m_bStarted = true;
            }
        }
        return this.m_bStarted;
    }

    public boolean stopCellEditing() {
        if (this.m_bStarted && this.m_bEnabled) {
            int result = this.updateCurrentValue();
            if (result == 2) {
                this.fireEditingStopped();
                this.m_bStarted = false;
                this.m_bEnabled = false;
            } else if (result != 0) {
                this.cancelCellEditing();
            }
        }
        return !this.m_bStarted;
    }

    public void actionPerformed(ActionEvent e) {
        int result = this.updateCurrentValue();
        if (result == 2) {
            this.fireEditingStopped();
        } else if (result != 0) {
            this.cancelCellEditing();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int result = this.updateCurrentValue();
        if (result == 2) {
            this.fireEditingStopped();
        } else if (result != 0) {
            this.cancelCellEditing();
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (this.m_editArrayDialog != null && this.m_editArrayDialog.isVisible()) {
            return;
        }
        if (this.m_assignAttachmentDialog != null) {
            return;
        }
        if (this.m_editXMLDialog != null && this.m_editXMLDialog.isVisible()) {
            return;
        }
        int nResult = this.updateCurrentValue();
        if (nResult == 2) {
            this.fireEditingStopped();
        } else if (nResult != 0) {
            this.cancelCellEditing();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (!this.m_bStarted) {
            this.shouldSelectCell(event);
            return;
        }
        if (event.getKeyChar() == '\r') {
            int result = this.updateCurrentValue();
            if (result == 2) {
                this.fireEditingStopped();
            } else if (result != 0) {
                this.cancelCellEditing();
            }
        }
    }

    protected int updateCurrentValue() {
        if (this.m_bUpdatingValue) {
            return 0;
        }
        int nResult = 1;
        try {
            this.m_bUpdatingValue = true;
            block5 : switch (this.m_nEditorType) {
                case 0: {
                    if (this.getComponent() == null) {
                        return 1;
                    }
                    String string = ((JTextField)this.getComponent()).getText();
                    if (VWStringUtils.compare(string, VWResource.s_variousValues) == 0) {
                        nResult = 1;
                        break;
                    }
                    switch (this.m_nFieldType) {
                        case 1: {
                            try {
                                Integer newIntValue = new Integer(string);
                                if (this.m_currentValue instanceof Integer && newIntValue.equals(this.m_currentValue)) {
                                    nResult = 1;
                                    break block5;
                                }
                                this.m_currentValue = newIntValue;
                                nResult = 2;
                            }
                            catch (NumberFormatException ex) {
                                this.m_textField.removeFocusListener(this);
                                this.selectCurrentCell();
                                JOptionPane.showMessageDialog(null, VWResource.s_invalidIntegerFormat, VWResource.s_error, 1, null);
                                nResult = 3;
                            }
                            break block5;
                        }
                        case 8: {
                            try {
                                Number newNumberValue = VWFieldsCellRenderer.parse(string);
                                Double newFloatValue = new Double(newNumberValue.doubleValue());
                                if (this.m_currentValue instanceof Double && newFloatValue.equals(this.m_currentValue)) {
                                    nResult = 1;
                                    break block5;
                                }
                                this.m_currentValue = newFloatValue;
                                nResult = 2;
                            }
                            catch (ParseException ex) {
                                this.m_textField.removeFocusListener(this);
                                this.selectCurrentCell();
                                JOptionPane.showMessageDialog(null, VWResource.s_invalidFloatFormat, VWResource.s_error, 1, null);
                                nResult = 3;
                            }
                            break block5;
                        }
                        case 16: {
                            Date date = null;
                            int count = s_dateTimeFormatters.length;
                            for (int i = 0; i < count; ++i) {
                                try {
                                    date = s_dateTimeFormatters[i].parse(string);
                                    if (date == null) continue;
                                    break;
                                }
                                catch (ParseException ex) {
                                    if (i != count - 1) continue;
                                    this.m_textField.removeFocusListener(this);
                                    this.selectCurrentCell();
                                    JOptionPane.showMessageDialog(null, VWResource.s_invalidDateTimeFormat, VWResource.s_error, 1, null);
                                    nResult = 3;
                                }
                            }
                            if (nResult == 3) break block5;
                            if (this.m_currentValue instanceof Date && date.equals(this.m_currentValue)) {
                                nResult = 1;
                                break block5;
                            }
                            this.m_currentValue = date;
                            nResult = 2;
                            break block5;
                        }
                        case 512: {
                            try {
                                VWGuid newGuid = null;
                                newGuid = string == null || string.length() == 0 ? new VWGuid() : new VWGuid(string);
                                if (this.m_currentValue instanceof VWGuid && newGuid.equals(this.m_currentValue)) {
                                    nResult = 1;
                                    break block5;
                                }
                                this.m_currentValue = newGuid;
                                nResult = 2;
                            }
                            catch (VWException ex) {
                                this.m_textField.removeFocusListener(this);
                                this.selectCurrentCell();
                                JOptionPane.showMessageDialog(null, ex.getMessage(), VWResource.s_error, 1, null);
                                nResult = 3;
                            }
                            break block5;
                        }
                    }
                    if (this.m_currentValue instanceof String && VWStringUtils.compare(string, (String)this.m_currentValue) == 0) {
                        nResult = 1;
                        break;
                    }
                    this.m_currentValue = string;
                    nResult = 2;
                    break;
                }
                case 1: {
                    int index = this.m_comboBox.getSelectedIndex();
                    Boolean newBooleanValue = index == 0;
                    if (this.m_currentValue instanceof Boolean && newBooleanValue.equals(this.m_currentValue)) {
                        nResult = 1;
                        break;
                    }
                    this.m_currentValue = newBooleanValue;
                    nResult = 2;
                    break;
                }
                case 2: {
                    if (this.m_editArrayDialog != null) {
                        if (this.m_editArrayDialog.isCanceled()) {
                            nResult = 1;
                            break;
                        }
                        this.m_currentValue = this.m_editArrayDialog.getFieldArray();
                        nResult = 2;
                        break;
                    }
                    nResult = 1;
                    break;
                }
                case 3: {
                    nResult = 1;
                    if (this.m_assignAttachmentDialog == null) break;
                    VWAttachment newAttachment = null;
                    if (0 == this.m_nAssignAttachmentDialogReturn) {
                        IVWIDMItem idmItem = this.m_assignAttachmentDialog.getSelectedItem();
                        if (idmItem != null) {
                            newAttachment = idmItem.getVWAttachment();
                        }
                    } else {
                        String fileName;
                        if (2 != this.m_nAssignAttachmentDialogReturn) break;
                        VWFileURLDialog URLDlg = new VWFileURLDialog(this.m_parentFrame);
                        int nURLReturnVal = URLDlg.showDialog(this.m_parentFrame);
                        if (nURLReturnVal == 0 && (fileName = URLDlg.getSelectedFile()) != null) {
                            newAttachment = new VWAttachment();
                            newAttachment.setType(5);
                            newAttachment.setId(fileName);
                        }
                    }
                    if (newAttachment != null) {
                        VWAttachment oldAttachment;
                        nResult = 2;
                        if (this.m_currentValue != null && this.m_currentValue instanceof VWAttachment && VWStringUtils.compare((oldAttachment = (VWAttachment)this.m_currentValue).toString(), newAttachment.toString()) == 0) {
                            nResult = 1;
                        }
                        if (nResult != 1) {
                            this.m_currentValue = newAttachment;
                        }
                    }
                    break;
                }
                case 5: {
                    nResult = 1;
                    if (this.m_editXMLDialog == null) break;
                    VWXMLData updatedXMLData = null;
                    if (this.m_nEditXMLDialogReturn != 0 || (updatedXMLData = this.m_editXMLDialog.getVWXMLData()) == null) break;
                    nResult = 2;
                    if (this.m_bRuntimeData) {
                        VWXMLData oldXMLData;
                        if (this.m_currentValue != null && this.m_currentValue instanceof VWXMLData && VWStringUtils.compare((oldXMLData = (VWXMLData)this.m_currentValue).getXML(), updatedXMLData.getXML()) == 0) {
                            nResult = 1;
                        }
                        if (nResult == 1) break;
                        this.m_currentValue = updatedXMLData;
                        break;
                    }
                    this.m_currentValue = updatedXMLData;
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_editField, 0);
        }
        this.m_bUpdatingValue = false;
        return nResult;
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.m_changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.m_changeEvent);
        }
    }

    private void selectCurrentCell() {
        if (this.m_table != null) {
            if (this.m_row != -1) {
                this.m_table.setRowSelectionInterval(this.m_row, this.m_row);
            }
            if (this.m_col != -1) {
                this.m_table.setColumnSelectionInterval(this.m_col, this.m_col);
            }
        }
    }
}

